<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Resumen;
use App\Models\DetalleResumen;
use App\Models\Venta;
use App\Models\Empresa;


class ResumenController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function listar()
    {
        $res = Resumen::where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('resumen.listar', [ 'data' => $res]); 
    }


    public function detalles($id)
    {
        return view('resumen.detalles', [
            'data' => Resumen::where(['id_resumen' => $id , 'estado' => 1])->first(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
            'detalle_resumen' => DetalleResumen::with(['venta', 'nota'])->where(['id_resumen' => $id , 'estado' => 1])->get(),
        ]); 
    }

    public function estado($id)
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'PENDIENTE'];

        $res = Resumen::where('estado_envio', $estado[$id])->where('estado', 1)->orderBy('fecha_referencia', 'desc')->paginate(20);

        return view('resumen.listar', [ 'data' => $res]); 
    }

}
