<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleVenta extends Model
{
    protected $table = 'detalle_venta';
    protected $primaryKey = 'id_detalle_venta';

    protected $fillable = [
        'id_detalle_venta','id_venta', 'id_producto', 'cantidad', 'precio_venta', 'impuesto', 'precio_venta_neto', 'descuento', 'precio_venta_total', 'estado'
    ];

    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
