<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEgresosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('egresos', function (Blueprint $table) {
            $table->integer('id_egreso')->autoIncrement();
            $table->integer('id_local');
            $table->integer('id_usuario');
            $table->string('tipo_egreso', 10)->nullable(); //FIJO, VARIABLE
            $table->string('concepto', 15)->nullable(); //OBLIGACIONES, SERVICIOS, SUELDOS, IMPREVISTOS, OTROS
            $table->string('descripcion', 200)->nullable(); 
            $table->string('tipo_comprobante', 15)->nullable(); // RECIBO, BOLETA, FACTURA, VOUCHER, OTRO 
            $table->string('numero_comprobante', 20)->nullable();  
            $table->decimal('monto', 9, 2)->nullable(); 
             $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_local')->references('id_local')->on('local'); 
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('egresos');
    }
}
