<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProformasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('proformas', function (Blueprint $table) {
            $table->integer('id_proforma')->autoIncrement();
            $table->integer('id_usuario');
            $table->integer('id_local');
            $table->string('nombre', 200)->nullable(); 
            $table->string('numero_documento', 15)->nullable();
            $table->string('direccion', 200)->nullable();
            $table->date('fecha_emision')->nullable();
            $table->decimal('total', 9, 2)->nullable();
            $table->decimal('adelanto', 9, 2)->nullable();
            $table->decimal('saldo', 9, 2)->nullable();
            $table->string('tipo', 20)->default('PROFORMA'); 
            $table->string('observacion', 200)->nullable();

            $table->tinyInteger('genera_venta')->default('0'); 

            $table->tinyInteger('estado')->default('1'); 
            $table->timestamps();

            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios');    
 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proformas');
    }
}
