<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];
	$impuesto = $_GET['impuesto'];
	$tipo = $_GET['tipo'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_local == 0) {
		$consulta = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.lote, p.situacion_impuesto, ve.fecha_venta, v.precio_venta, v.descuento, v.cantidad , v.precio_venta_total as total, v.impuesto, v.precio_venta_neto, ve.nombre_comprobante, c.nombre as c_nombre, c.numero_documento as c_documento , u.nombres as nom_personal, u.apellidos as ap_personal, lo.nombre as sucursal, lo.direccion as dir_local FROM detalle_venta v INNER JOIN ventas ve ON ve.id_venta = v.id_venta INNER JOIN productos p ON p.id_producto = v.id_producto INNER JOIN clientes c ON c.id_cliente = ve.id_cliente INNER JOIN usuarios u ON u.id_usuario = ve.id_usuario INNER JOIN local lo ON ve.id_local = lo.id_local WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") AND ve.id_nota IS NULL AND ve.estado="1" AND ve.id_tipo_comprobante="'.$tipo.'" AND p.situacion_impuesto LIKE "'.$impuesto.'" ORDER BY v.id_venta';
	} else{
		$consulta = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.lote, p.situacion_impuesto, ve.fecha_venta, v.precio_venta, v.descuento, v.cantidad , v.precio_venta_total as total, v.impuesto, v.precio_venta_neto, ve.nombre_comprobante, c.nombre as c_nombre, c.numero_documento as c_documento , u.nombres as nom_personal, u.apellidos as ap_personal , lo.nombre as sucursal, lo.direccion as dir_local  FROM detalle_venta v INNER JOIN ventas ve ON ve.id_venta = v.id_venta INNER JOIN productos p ON p.id_producto = v.id_producto INNER JOIN clientes c ON c.id_cliente = ve.id_cliente INNER JOIN usuarios u ON u.id_usuario = ve.id_usuario INNER JOIN local lo ON ve.id_local = lo.id_local WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") AND ve.id_local="'.$id_local.'" AND ve.id_nota IS NULL AND ve.estado="1" AND ve.id_tipo_comprobante="'.$tipo.'" AND p.situacion_impuesto LIKE "'.$impuesto.'" ORDER BY v.id_venta';
	}

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS VENDIDOS")
									 ->setSubject("Reporte de PRODUCTOS VENDIDOS")
									 ->setDescription("Reporte de PRODUCTOS VENDIDOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS VENDIDOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'PRODUCTO')
		            ->setCellValue('C2', 'CODIGO BARRAS')
		            ->setCellValue('D2', 'MARCA')
					->setCellValue('E2', 'SITUACION DE IMPUESTO')
					->setCellValue('F2', 'CANTIDAD')
					->setCellValue('G2', 'PRECIO UNITARIO S/')
					->setCellValue('H2', 'DESCUENTO S/')
					->setCellValue('I2', 'SUBTOTAL S/')
					->setCellValue('J2', 'IGV S/')
					->setCellValue('K2', 'TOTAL S/')
					->setCellValue('L2', 'N° COMPROBANTE')
					->setCellValue('M2', 'NOMBRE DE CLIENTE')
					->setCellValue('N2', 'N° DOC CLIENTE')
					->setCellValue('O2', 'PERSONAL QUE REGISTRO LA VENTA')
					->setCellValue('P2', 'FECHA DE VENTA')
					->setCellValue('Q2', 'SUCURSAL');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:Q2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(150);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(100);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['codigo_barras'])
			
			    ->setCellValue('D'.$i,  utf8_encode($fila['descripcion']))
			    ->setCellValue('E'.$i,  utf8_encode($fila['situacion_impuesto']))
			    ->setCellValue('F'.$i, $fila['cantidad'])
			    ->setCellValue('G'.$i, $fila['precio_venta'])
			    ->setCellValue('H'.$i, $fila['descuento'])

			    ->setCellValue('I'.$i, $fila['precio_venta_neto'])
			    ->setCellValue('J'.$i, $fila['impuesto'])
			    ->setCellValue('K'.$i, $fila['total'])

			    ->setCellValue('L'.$i, $fila['nombre_comprobante'])
			    ->setCellValue('M'.$i, utf8_encode($fila['c_nombre']))
			    ->setCellValue('N'.$i, $fila['c_documento'])
			    ->setCellValue('O'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
			    ->setCellValue('P'.$i, $fila['fecha_venta'])
			    ->setCellValue('Q'.$i, utf8_encode($fila['sucursal'].' '.$fila['dir_local']));
			$i++;
			$j++;
			$suma = $suma+$fila['total'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('J'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('K'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('I'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('J'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('K3:K'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "Q".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos Vendidos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Productos_Vendidos.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






