$(function () {

	var size_imagen = 0;

	$.fn.form.settings.rules.codigoExiste = function(value) {
	  	return (verificaExiste('codigo_barras', value) > 0 ? false : true);
	};
    $('[data-tab="one"]').form({
    	keyboardShortcuts: false,
    	fields: {
    		id_local: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opcion'}]
		    },
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    cantidad: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    stock_alerta: {
		    	optional: true,
		        rules: [
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    codigo_barras: {
		    	optional: true,
		        //rules: [{ type : 'codigoExiste', prompt : 'Este codigo ya fue registrado en otro producto'}]
		    },
    	},
    	inline : true,
    });

    $('[data-tab="two"]').form({
    	keyboardShortcuts: false,
    	fields: {

		    precio: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    },
		    precio_mayorista: {
		    	optional: true,
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    },
		    precio_compra: {
		    	optional: true,
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    },
		    valor_impuesto: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    imagen : {
		    	optional: true,
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^(.*.((png|jpg|jpeg|gif)$))?[^.]*$/i]', prompt : 'Seleccione una imagen valida'},
		        ]
		    },
    	},
    	inline : true,
    });

    function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/producto/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('.tab_one').on('click', function() {
    	$.tab('change tab', 'one');
  	});
	$('.tab_two').on('click', function() {
		if ($('[data-tab="one"]').form('is valid')) {
			$.tab('change tab', 'two');
		} else {
			$('[data-tab="one"]').form('validate form');
		}
  	});

	$('.btn_registrar').on('click', function() {
		if ($('[data-tab="two"').form('is valid')) {
			if ( $('[name="precio"]').val() != 0 ) {
				if ( size_imagen <= 2 ) {
					$('#register_modal').modal({
		  				closable: false,
				    	onApprove : function() {
				    		sendForm();
					    }
			  		}).modal('show'); 
			  	} else {
					swal("La imagen", "que intenta subir es muy grande, tamaño maximo 2MB", "warning");
				}	
			}
			else {
				swal("El precio de venta", "NO puede ser cero", "warning");
			}
		} else {
			$('[data-tab="two"').form('validate form');
		}
  	});

	function sendForm() {

	   var form = $('#frmNuevo')[0];
       var data = new FormData(form); 
	   
        $.requestApiFile('/producto/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            if (resolve.message === "success") {
	                $.Helper.clearFields("#frmNuevo", ["valor_impuesto", "stock_alerta"]);
	                $.tab('change tab', 'one');
	            }
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

	/******************************************************************************/
	/* validacion porcentaje en precio de compra y venta de modal productos
	/******************************************************************************/


	$('[name="tipo_precio"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "1") {
			$('[data-tab="two"]').form('remove fields', ['precio_compra']);
			$('[data-tab="two"]').form('remove prompt', ['precio_compra']);
			$('[data-tab="two"]').form('add rule', 'precio_compra', {
				optional: true,
		        rules: [{type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'}]
		    });
		}
		if (option == "2") {
			$('[data-tab="two"]').form('add rule', 'precio_compra', {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    });
		}
	});

	$('[name="tipo_precio"]').on('change', function(){
		if ($('[name="precio_compra"]').val() !== '' ) {
			$('[data-tab="two"]').form('remove prompt', ['precio_compra']);
		}
	}); 

	/******************************************************************************/
	/* validacion porcentaje en precio de compra y venta por mayor
	/******************************************************************************/

	$('[name="tipo_precio_2"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "1") {
			$('[data-tab="two"]').form('remove fields', ['precio_compra']);
			$('[data-tab="two"]').form('remove prompt', ['precio_compra']);
			$('[data-tab="two"]').form('add rule', 'precio_compra', {
				optional: true,
		        rules: [{type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'}]
		    });
		}
		if (option == "2") {
			$('[data-tab="two"]').form('add rule', 'precio_compra', {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    });
		}
	});

	$('[name="tipo_precio_2"]').on('change', function(){
		if ($('[name="precio_compra"]').val() !== '' ) {
			$('[data-tab="two"]').form('remove prompt', ['precio_compra']);
		}
	}); 

	/******************************************************************************/
	/* validacion igv de situacion impuesto
	/******************************************************************************/


	$('[name="situacion_impuesto"]').on('change', function(){
		if ($('[name="situacion_impuesto"]').val() !== 'AFECTO' ) {
			$('[name="valor_impuesto"]').val("0.00");
			//$('[name="valor_impuesto"]').attr('readonly', true);
		}
		else {
			$('[name="valor_impuesto"]').val(_IGV);
			//$('[name="valor_impuesto"]').attr('readonly', false);
		}
	}); 


	/******************************************************************************/
	/* input cargar productos
	/******************************************************************************/

	$('input:text, .ui.button', '#cargar-imagen').on('click', function(e) {
    	$('input:file', $(e.target).parents()).click();
	});

	$('input:file', '#cargar-imagen').on('change', function(e) {
	    var name = e.target.files[0].name;
	    $('input:text', $(e.target).parent()).val(name);

	    size_imagen = e.target.files[0].size/1024/1024;
	 
	});

});
