$(function () {

	$.fn.form.settings.rules.usernameExiste = function(value) {
	  	return (verificaExiste('username', value) > 0 ? false : true);
	};
	$.fn.form.settings.rules.emailExiste = function(value) {
	  	return (verificaExiste('email', value) > 0 ? false : true);
	};
    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
	      	nombres: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    apellidos: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    email: {
		    	optional: true,
		        rules: [
		        	{ type : 'emailExiste', prompt : 'Este email ya fue registrado'},
		        	{ type : 'email', prompt : 'Ingrese un email valido'}
		        ]
		    },
		    username: {
		        rules: [
		        	{ type : 'empty', prompt : 'Ingrese un nombre de usuario'},
		        	{ type   : 'regExp[/^\\b[a-zA-Z0-9_]+\\b$/]', prompt : 'Ingrese un nombre de usuario sin espacios'},
		        	{ type : 'usernameExiste', prompt : 'El nombre de usuario ya existe'},
		        ]
		    },
		    password: {
		        rules: [{type : 'empty', prompt : 'Ingrese una contraseña'}]
		    },
		    dni: {
		    	optional: true,
		        rules: [
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[8]', prompt : 'El dni debe tener {ruleValue} digitos'}
		        ]
		    },
		    id_rol: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    id_local: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    telefono: {
		        rules: [{ type : 'number', prompt : 'Ingrese solo números'}]
		    },
    	},
    	inline : true
    });

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/personal/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

	$('.btn_registrar').on('click', function() {
		if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmNuevo').form('validate form');
		}
  	});


	function sendForm() {

	    var data = $('#frmNuevo').serialize();
        $.requestApi('/personal/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            if (resolve.message === "success") {
	                $.Helper.clearFields("#frmNuevo");
	            }
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
