@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">COMUNICACION DE BAJA EMITIDAS</h4>
           
            <div class="ui equal width grid">
                <div class="row">
                    <div class="column export_files" style="text-align: right">
                        <select class="ui small input dropdown" name="estado_envio">
                            <option value="">Seleccione</option>
                            <option value="TODOS">TODOS</option>
                            <option value="0">ACEPTADOS</option>
                            <option value="1">RECHAZADOS</option>
                            <option value="2">NO ENVIADOS</option>
                            <option value="3">PENDIENTES</option>
                            <option value="4">REGISTRADOS</option>
                        </select>  
                    </div>
                </div>
            </div> 

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">N° Comunicacion</th>
                        <th class="head_table">Tienda</th>
                        <th class="head_table">Fecha Emision</th>
                        <th class="head_table">Fecha de Envio</th>
                        <th class="head_table">Estado</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $baja)
                        <tr>
                            <td>{{ $i }}</td>
                            <td>{{ $baja->nombre_baja}}</td>
                            <td>{{ $baja->local->nombre }}</td>
                            <td>{{ $baja->fecha_emision }}</td>
                            <td>{{ $baja->updated_at }}</td>
                            <td>
                                @if($baja->estado_envio == "ACEPTADO")
                                    <div class="ui green label">{{ $baja->estado_envio }}</div>
                                @elseif ($baja->estado_envio == "RECHAZADO")
                                    <div class="ui yellow label">{{ $baja->estado_envio }}</div>
                                @elseif ($baja->estado_envio == "NO ENVIADO")
                                    <div class="ui red label">{{ $baja->estado_envio }}</div>
                                @elseif ($baja->estado_envio == "PENDIENTE")
                                    <div class="ui purple label">{{ $baja->estado_envio }}</div> 
                                @elseif ($baja->estado_envio == "REGISTRADO")
                                    <div class="ui orange label">{{ $baja->estado_envio }}</div>     
                                @endif
                            </td>
                            <td>                            
                                <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('baja/detalles/'.$baja->id_baja) }}">
                                    <div class="hidden content">Detalles</div>
                                    <div class="visible content"><i class="search icon"></i></div>
                                </a>
                            </td>
                        </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/baja/listar.js') }}"></script>
@stop



