@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">EMISION DE COMUNICACION DE BAJA</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">

                <input type="hidden" id="id_tipo_comprobante" name="id_tipo_comprobante" value="{{ $data->id_tipo_comprobante }}">
                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Surcursal de Emision</div>
                    </div>
                    <div class="eight wide field">
                        <div class="ui small input ">
                          <input type="text" readonly value="{{ $data->local->nombre}} ({{ $data->local->direccion }})">
                        </div>
                    </div>
                </div>
                @if($tipo == 1 || $tipo == 2)   
                <input type="hidden" id="fecha_referencia" name="fecha_referencia" value="{{ $data->fecha_venta }}">
                <input type="hidden" id="id_venta" name="id_venta" value="{{ $data->id_venta }}">
                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Serie Comprobante</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input ">
                          <input type="text" maxlength="20" readonly value="{{ $data->serie_comprobante }}" name="serie">
                        </div>
                    </div>
                    <div class="three wide field">
                        <div class="ui fluid large white label">Numero Comprobante</div>
                    </div>
                    <div class="two wide field">
                        <div class="ui small input ">
                          <input type="text" maxlength="20" readonly value="{{ $data->numero_comprobante }}" name="numero">
                        </div>
                    </div>
                </div>
                @endif    
                @if($tipo == 3 || $tipo == 4)    
                <input type="hidden" id="fecha_referencia" name="fecha_referencia" value="{{ $data->fecha_emision }}">
                <input type="hidden" id="id_nota" name="id_nota" value="{{ $data->id_nota }}">
                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Serie Comprobante</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input ">
                          <input type="text" maxlength="20" readonly value="{{ $data->serie_nota }}" name="serie">
                        </div>
                    </div>
                    <div class="three wide field">
                        <div class="ui fluid large white label">Numero Comprobante</div>
                    </div>
                    <div class="two wide field">
                        <div class="ui small input ">
                          <input type="text" maxlength="20" readonly value="{{ $data->numero_nota }}" name="numero">
                        </div>
                    </div>
                </div>
                @endif

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Tipo de Comprobante</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input ">
                          <input type="text" maxlength="20" readonly value="{{ $data->tipo_comprobante->nombre }}">
                        </div>
                    </div>
                </div>
                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Motivo para Dar de Baja</div>
                    </div>
                    <div class="eight wide field">
                        <div class="ui small input ">
                          <input type="text" name="motivo"  maxlength="200" oninput="$.upperCase(this)" placeholder="Ejemplo: Anulacion de Factura">
                        </div>
                    </div>
                </div>

                <div class="form_footer">
                    <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>EMITIR</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Emitir Comunicacion de Baja</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea emitir la comunicacion de baja para este comprobante?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Emitir</div>
        </div>
    </div>
    <!--end register modal -->
    
@stop

@section('scripts')
    <script src="{{ asset('js/baja/nuevo.js') }}"></script>
@stop


