@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE PRODUCTOS RETIRADOS</h4>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Producto</th>
                        <th class="head_table">Cantidad Retirada</th>
                        <th class="head_table">Fecha de Retiro</th>
                        <th class="head_table">Local donde se retiro</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $row)
                    <tr data-table="{{ $row->id_retiro }}">
                        <td>{{ $i }}</td>
                        <td>{{ $row->producto->nombre }} {{ $row->producto->descripcion }}</td>
                        <td>{{ $row->cantidad_retiro }}</td>
                        <td>{{ $row->created_at}}</td>
                        <td>{{ $row->local->nombre }}</td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('retiro/detalles/'.$row->id_retiro) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="6">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop


