@extends('layout.main')
@section('content')
@if ($data)
    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE VENTA</h4>

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la venta:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column"><a href="{{ url('cliente/editar/'.$data->id_cliente) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($data->cliente->nombre)) }}</a> </div>
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">{{ $data->cliente->tipo_documento->nombre }} :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column">{{ $data->cliente->numero_documento }}</div>
                    </div>
                     <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente:</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ ucwords(mb_strtolower($data->cliente->direccion)) }}</div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->tipo_comprobante->nombre }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->nombre_comprobante }}</div>
                    </div>

                    <?php /**/ $subtotal = 0/**/ ?>
                    <?php /**/ $subtotal_total = 0/**/ ?>
                    <?php /**/ $igv = 0/**/ ?>
                    <?php /**/ $desc = 0/**/ ?>
                    @foreach ($detalle_venta as $row1)
                        <?php /**/  $subtotal = $subtotal + $row1->precio_venta_neto /**/ ?>
                        <?php /**/  $subtotal_total = $subtotal_total + $row1->precio_venta_total /**/ ?>
                        <?php /**/  $igv = $igv + $row1->impuesto /**/ ?>
                        <?php /**/  $desc = $desc + $row1->descuento /**/ ?>
                    @endforeach
                    <?php /**/  $icbper = $data->total_venta + $data->descuento_global - $subtotal_total  /**/ ?>

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_venta }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">TOTAL DE LA VENTA :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column" style="color:red">S/ {{ $data->total_venta }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Importe Neto :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ number_format($subtotal,2) }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">IGV :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ number_format($igv,2) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">ICBPER :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ number_format($icbper,2) }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Total Descuentos :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ number_format($desc,2) }}</div>
                    </div>
                    
                    @if ($data->id_nota != null)
                        <div class="row" style="padding-bottom: 0px !important">
                            <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Estado de comprobante:</div>
                            <div class="sixteen wide mobile eight wide tablet  twelve wide computer column" style="color: red!important">El comprobante fue ANULADO  <a style="text-decoration: underline;" href="{{ url('nota/detalles/'.$data->id_nota) }}">(ver detalles)</a></div>
                        </div>
                    @endif

                </div>
            </div>
            
            @if($data->tipo_pago == 'CREDITO')
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">AL {{ $data->tipo_pago }}</div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Detalle de pagos:</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><a style="text-decoration: underline;" href="{{ url('venta/detalles_deuda/'.$data->id_venta) }}">Ver</a></div>
                    </div>
                </div>
            </div>
            @endif

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned" data-tooltip="Monto de Descuento" data-position="top center" data-inverted="">Dscto S/</th> 
                        <th class="center aligned">Subtotal</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    @foreach ($detalle_venta as $venta)
                    <tr data-table="{{ $venta->id_detalle_venta }}">
                        <td><a href="{{ url('producto/editar/'.$venta->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($venta->producto->nombre)) }} {{ $venta->producto->descripcion }}</a></td>
                        <td>{{ $venta->producto->unidad_medida->nombre }}</td>
                        <td>{{ $venta->cantidad }}</td>
                        <td>{{ $venta->precio_venta }}</td>
                        <td>{{ $venta->descuento==0 ? $venta->descuento : '-'.$venta->descuento  }}</td> 
                        <td class="warning">{{ $venta->precio_venta_total }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

                <?php /**/ $date1 = new DateTime() /**/ ?>
                <?php /**/ $date2 = new DateTime($data->fecha_venta) /**/ ?>
                <?php /**/ $total = $date1->diff($date2)->days /**/ ?>


                @if($data->id_nota == null  && $total < 90 && ($data->id_tipo_comprobante == 2 || ($data->id_tipo_comprobante == 1 && $data->estado_envio == 'ACEPTADO')))
                    <a class="ui small right floated red button btn_anular" href="{{ url('nota/credito/'.$data->id_venta) }}"><i class="times icon"></i>Anular Venta</a>
                @endif


                @if($data->id_nota == null)
                    <div class="ui small right floated primary button btn_imprimir" data-id="{{ $data->id_venta }}"><i class="print icon"></i>Imprimir Ticket</div>
                    <div class="ui small right floated green button btn_imprimir_a4" data-id="{{ $data->id_venta }}"><i class="print icon"></i>Imprimir A4</div>
                @else
                    <div class="ui small right floated green button btn_imprimir_nota_a4" data-id="{{ $data->id_nota }}"><i class="print icon"></i>Imprimir A4</div>
                @endif



                
                <div class="ui small right floated violet  button btn_enviar"><i class="paper plane icon"></i>Enviar a Correo</div>

                <div class="ui small right floated teal  button btn_whatsapp" title="Enviar Comprobante a Whatsapp"><i class="whatsapp icon"></i>Whatsapp</div>



                
            </div>  

        </div>
    </div>

    <!--start mail modal -->
    <div class="ui standard tiny modal" id="email_modal">
        <div class="header">Enviar comprobante a email de cliente</div>
        <div class="content">
            <div class="description">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="margin-top: 5px;text-align: right"><b>Correo electronico : </b></div>
                        <div class="eleven wide column">
                            <div class="ui small fluid input " id="frmEmail">
                                <input type="text" name="email_cliente" id="email_cliente" size="20" maxlength="100" value="{{ $data->cliente->email }}" placeholder="juan@gmail.com">
                            </div>
                            <div class="ui error message" style="visibility: hidden;">Ingrese un email valido</div>
                        </div>
                    </div> 
                </div>
            </div>
        </div>   
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            @if($data->id_nota == null)
                <div class="ui right floated primary button btn_enviar_correo"  data-id="{{ $data->id_venta }}"><i class="paper plane icon"></i>ENVIAR</div>
            @else
                <div class="ui right floated primary button btn_enviar_correo_nota"  data-id="{{ $data->id_nota }}"><i class="paper plane icon"></i>ENVIAR</div>
            @endif

        </div>
    </div>
    <!--end mail modal -->


    <!--start mail modal -->
    <div class="ui standard tiny modal" id="whatsapp_modal">
        <div class="header">Enviar comprobante a Whatsapp de cliente</div>
        <div class="content">
            <div class="description">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="margin-top: 5px;text-align: right"><b>Numero de Celular : </b></div>
                        <div class="eleven wide column">
                            <div class="ui small fluid input " id="frmNumero">
                                <input type="text" name="numero_cliente" id="numero_cliente" size="20" maxlength="9" value="{{ $data->cliente->email }}" placeholder="987654321">
                            </div>
                            <div class="ui error message" style="visibility: hidden;">Ingrese un numero valido</div>
                        </div>
                    </div> 
                </div>
            </div>
        </div>   
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            @if($data->id_nota == null)
                <div class="ui right floated primary button btn_enviar_whatsapp"  data-id="{{ $data->id_venta }}"><i class="paper plane icon"></i>ENVIAR</div>
            @else
                <div class="ui right floated primary button btn_enviar_whatsapp_nota"  data-id="{{ $data->id_nota }}"><i class="paper plane icon"></i>ENVIAR</div>
            @endif
        </div>
    </div>
    <!--end mail modal -->
@else
    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            <h3 class="ui header black centered">No se puede realizar esta accion</h3>
        </div>
    </div>    
@endif
 
@stop

@section('scripts')
    <script src="{{ asset('js/venta/detalles.js') }}"></script>
@stop


